/*
 * backtrace.c - demo
 *
 * Copyright (C) 2009  Carsten Emde <C.Emde@osadl.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307,
 * USA.
 */
#include <stdio.h>
#include <signal.h>
#include <stdlib.h>
#include <execinfo.h>
#include <math.h>

#define __USE_GNU
#include <fenv.h>

#define MAXFRAMES 20

static void privileged(void)
{
	asm("wbinvd");
}

static void crash_it(char which)
{
	char buffer[32];
	int *crash = NULL;
	int i = 1, j = 0;
	double k = 0.0, l = -1.0;
	void (*illegal)(void) = (void (*)(void)) 0x0123456701234567;

	if (which == 'a') {
		printf("Forcing exception handling by dereferencing 0x%08x\n",
		    crash);
		printf("printf %d\n", *crash);
	} else if (which == 'p') {
		printf("Forcing exception handling by executing a privileged "
		    "instruction\n");
		privileged();
	} else if (which == 'i') {
		printf("Forcing exception handling by executing a non-existing "
		    "opcode\n");
		illegal();
	} else if (which == '0') {
		printf("Forcing exception handling by division by 0\n");
		printf("printf %d\n", i / j);
	} else if (which == '.') {
		feenableexcept(FE_INVALID);
		printf("Forcing exception handling by division by 0.0\n");
		printf("printf %f\n", k / k);
	} else if (which == 'n') {
		feenableexcept(FE_INVALID);
		printf("Forcing exception handling by square root of a "
		    "negative number\n");
 		printf("printf %f\n", sqrt(l));
	} else
		printf("What?\n");
}

static char shell[256];
static void trace_it(int signo)
{
	void *stack[MAXFRAMES];
	char **symbols;
	int i, count = backtrace(stack, MAXFRAMES);

	printf("Caught signal %d\n", signo);

	printf("Stacktrace:\n");
	symbols = backtrace_symbols(stack, count);
        for (i = 0; i < count; i++)
		printf("Frame %d: 0x%08x (%s)\n", i+1, stack[i], symbols[i]);

	if (count >= 4) {
		sprintf(shell, "addr2line -e backtrace 0x%08x", stack[count - 5]);
		printf("Executing\n  %s\nlocates the problem\n  ", shell);
		fflush(stdout);
		system(shell);
	}
	free(symbols);
}


void signal_handler(int signo)
{
	trace_it(signo);
	exit(signo);
}


int main(int argc, char *argv[])
{
	signal(SIGSEGV, signal_handler);
	signal(SIGFPE, signal_handler);

	crash_it(argc == 1 ? 'a' : argv[1][0]);
}
